<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WP_Bootstrap_Starter
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="shortcut icon" href="<?php echo site_url(); ?>/favicon.ico?v=2" type="image/x-icon">
    <link rel="icon" href="<?php echo site_url(); ?>/favicon.ico?v=2" type="image/x-icon">
    <title><?php
    $meta_title = get_post_meta(get_the_ID(), '_yoast_wpseo_title', true);
    // If the meta description is not set, you can use the excerpt as a fallback
    if (empty($meta_title)) {
        $meta_title = get_the_title();
    }
    echo $meta_title;
    ?></title>
    <meta name="description" content=" <?php 
    $meta_description = get_post_meta(get_the_ID(), '_yoast_wpseo_metadesc', true);
    // If the meta description is not set, you can use the excerpt as a fallback
    if (empty($meta_description)) {
        $meta_description = get_the_excerpt();
    }
    echo $meta_description;
    ?>
    ">
    <meta name="keywords" lang="de" content="">
    <meta name="author" content="Dario Bellotta | DarioEvaristoBellotta | https://darioevaristobellotta.de">
    <script type="application/ld+json"> 
    { "@context" : "http://schema.org", "@type" : "LocalBusiness", "name" : "", "image": "", "email": "", "url": "", "address" : { "@type" : "PostalAddress", "addressLocality" : "", "postalCode" : "", "addressCountry": "" } } 
    </script>
    <?php $url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']; ?>
    <!-- Open Graph protocol -->
    <meta property="og:url" content="<?php echo $url ?>">
    <meta property="og:type" content="website">
    <meta property="og:title" content="<?php echo $meta_title; ?>">
    <meta property="og:description" content="<?php echo $meta_description; ?>">
    <meta property="og:image" content="
    <?php
    $social_image = get_post_meta(get_the_ID(), '_yoast_wpseo_opengraph-image', true);

    // If the social image is not set, you can use a default fallback
    if (empty($social_image)) {
        $social_image = '';
    }

    echo $social_image;
    ?>
    ">
    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="<?php wp_title( '|', true, 'right' ); ?>">
    <meta property="twitter:url" content="<?php echo $url ?>">
    <meta name="twitter:title" content="<?php echo $meta_title; ?>">
    <meta name="twitter:description" content=" <?php echo $meta_description; ?>">
    <meta name="twitter:image" content="<?php echo $social_image; ?>">
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600;700&family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <!-- JQuery JS -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <!-- MDB JS -->
    <script src="<?php echo site_url(); ?>/wp-content/themes/wp-bootstrap-starter-child/js/mdb.min.js"></script>
    <!-- Custom JS -->
    <script src="/wp-content/themes/wp-bootstrap-starter-child/js/script.js"></script>
    <!-- Fontawesome JS -->
    <script src="https://kit.fontawesome.com/0d2f09bcd0.js" crossorigin="anonymous"></script>
    <!-- Favicons -->
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo get_template_directory_uri(); ?>/favicon/favicon-96x96.png?v=4">
    <link rel="icon" type="image/svg+xml" href="<?php echo get_template_directory_uri(); ?>/favicon/favicon.svg?v=4">
    <link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/favicon/favicon.ico?v=4">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri(); ?>/favicon/apple-touch-icon.png?v=4">
    <link rel="manifest" href="<?php echo get_template_directory_uri(); ?>/favicon/site.webmanifest?v=4">
    <!-- Disable autodetection for phone numbers on Safari -->
    <meta name="format-detection" content="telephone=no">
    <!-- Chrome, Firefox OS and Opera -->
    <meta name="theme-color" content="#ffffff">
    <!-- Windows Phone -->
    <meta name="msapplication-navbutton-color" content="#ffffff">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="white">
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <!-- <script async src="https://www.googletagmanager.com/gtag/js?id=YOUR GOOGLE PROPERTY ID"></script> -->
    <script>
        /*
    var gaProperty = 'YOUR GOOGLE PROPERTY ID';
    var disableStr = 'ga-disable-' + gaProperty;
    if (document.cookie.indexOf(disableStr + '=true') > -1) {
        window[disableStr] = true;
    }
    function gaOptout() {
        document.cookie = disableStr + '=true; expires=Thu, 31 Dec 2099 23:59:59 UTC; path=/';
        window[disableStr] = true;
        alert('Das Tracking durch Google Analytics wurde in Ihrem Browser für diese Website deaktiviert.');
    }

    var gaOptOut='ga-disable-G-QVSQPYTP2L';
    if (document.cookie.indexOf(gaOptOut+'=true')>-1) window[gaOptOut]=true;
        window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());
        gtag('config', 'G-QVSQPYTP2L', { 'anonymize_ip': true });
        */
    </script>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

    <?php 

    // WordPress 5.2 wp_body_open implementation
    if ( function_exists( 'wp_body_open' ) ) {
        wp_body_open();
    } else {
        do_action( 'wp_body_open' );
    }

    ?>

    <div id="page" class="site">
       <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'wp-bootstrap-starter' ); ?></a>
       <?php if(!is_page_template( 'blank-page.php' ) && !is_page_template( 'blank-page-with-container.php' )): ?>
       <header id="masthead" class="site-header navbar-static-top sticky-top <?php echo wp_bootstrap_starter_bg_class(); ?>" role="banner">
        <div class="container">
            <nav class="navbar navbar-expand-xl p-0">
                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#main-nav" aria-controls="" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <?php
                                     wp_nav_menu(array(
                    'theme_location'    => 'primary',
                    'container'       => 'div',
                    'container_id'    => 'main-nav',
                    'container_class' => 'collapse navbar-collapse justify-content-end',
                    'menu_id'         => false,
                    'menu_class'      => 'navbar-nav',
                    'depth'           => 3,
                    'fallback_cb'     => 'wp_bootstrap_navwalker::fallback',
                    'walker'          => new wp_bootstrap_navwalker()
                ));
                ?>
                <div class="navbar-brand">
                    <a class="site-title" href="<?php echo esc_url( home_url( '/' )); ?>">
                        <img id="nav-logo" src="/wp-content/uploads/2025/10/Logo-Placeholder-02.png" alt="LOGO" title="LOGO" width="50" height="50"/>
                    </a>
                </div>
                <div id="nav-socials">
                      <a class="fb-ic" href="#" title="Go to Instagram" target="_blank">
                        <i class="fa-brands fa-instagram"></i>
                    </a>
                    <a class="nav-socials-mobile-hide tw-ic" href="#" title="Go to LinkedIn" target="_blank">
                        <i class="fa-brands fa-linkedin-in"></i>
                    </a>
                    <a class="nav-socials-mobile-hide" href="#" title="E-Mail"><i class="fa-solid fa-paper-plane"></i></a>
                </div>



            </nav>
        </div>
    </header><!-- #masthead -->
    <?php if(is_front_page() && !get_theme_mod( 'header_banner_visibility' )): ?>
    <!-- Full Page Intro -->
    <div id="intro-section" class="view">

 </div>
                  <!-- Full Page Intro --
    <?php endif; ?>
	<div id="content" class="site-content">
		<div class="container">
			<div class="row">
                <?php endif; ?>